*
* Out-of-sample forecasts
*
open data nile.dat
calendar 1871
data(format=free,org=columns,skips=1) 1871:1 1970:1 nile
*
* Kalman filter through the data period
*
dlm(a=1.0,c=1.0,sv=15099.0,sw=1469.1,presample=diffuse,y=nile,$
  type=filter) / xstates vstates
*
* Forecast out of sample for 10 years
*
dlm(a=1.0,c=1.0,sv=15099.0,sw=1469.1,$
  x0=xstates(1970:1),sx0=vstates(1970:1),$
  yhat=yhat,svhat=svhat) 1971:1 1980:1
set forecast 1971:1 1980:1 = %scalar(yhat)
set stderr   1971:1 1980:1 = sqrt(%scalar(svhat))
*
set lower 1971:1 1980:1 = forecast+%invnormal(.25)*stderr
set upper 1971:1 1980:1 = forecast+%invnormal(.75)*stderr
graph(footer="Out-of-sample Forecasts with 50% CI") 4
# nile     1931:1 1970:1
# forecast / 2
# lower    / 3
# upper    / 3

